/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen;

import net.minecraft.class_32;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7145;
import net.minecraft.class_7723;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.datafixer.DataFixerAPI;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.client.ClientWorldLifecycle;
import org.betterx.wover.events.api.types.CreatedNewWorldFolder;
import org.betterx.wover.events.api.types.OnFolderReady;
import org.betterx.wover.events.api.types.client.BeforeClientLoadScreen;

public class LevelGenEvents {
    public static void setupWorld() {
        DataExchangeAPI.prepareServerside();
    }

    public static void register() {
        WorldLifecycle.WORLD_FOLDER_READY.subscribe((Subscriber)((OnFolderReady)LevelGenEvents::beforeWorldLoad));
        WorldLifecycle.CREATED_NEW_WORLD_FOLDER.subscribe((Subscriber)((CreatedNewWorldFolder)LevelGenEvents::afterWorldCreation), 10000);
        ClientWorldLifecycle.BEFORE_CLIENT_LOAD_SCREEN.subscribe((Subscriber)((BeforeClientLoadScreen)LevelGenEvents::patchExistingWorldOnClient), 10000);
        WorldLifecycle.WORLD_FOLDER_READY.subscribe((Subscriber)((OnFolderReady)LevelGenEvents::patchExistingWorldOnServer), 10000);
        WorldLifecycle.WORLD_FOLDER_READY.subscribe((Subscriber)((OnFolderReady)LevelGenEvents::initializeWorldConfig), 10100);
    }

    private static void initializeWorldConfig(class_32.class_5143 storageAccess) {
    }

    private static void patchExistingWorldOnServer(class_32.class_5143 storageAccess) {
        if (ModCore.isServer()) {
            DataFixerAPI.fixData(storageAccess, false, b -> {});
        }
    }

    private static void patchExistingWorldOnClient(class_32.class_5143 storageAccess, BeforeClientLoadScreen.ContinueWith continueWith) {
        if (!DataFixerAPI.fixData(storageAccess, BCLib.isClient(), b -> continueWith.loadingScreen())) {
            continueWith.loadingScreen();
        }
    }

    private static void afterWorldCreation(class_32.class_5143 levelStorageAccess, class_5455 registryAccess, class_6880<class_7145> worldPresetHolder, class_7723 worldDimensions, boolean b) {
        LevelGenEvents.beforeWorldLoad(levelStorageAccess);
        DataFixerAPI.initializePatchData();
    }

    private static void beforeWorldLoad(class_32.class_5143 levelStorageAccess) {
        LevelGenEvents.setupWorld();
    }
}

